! -------------------------------------------------------------------------
!   Menus.h           A library extension providing easier and better menus
!                                                      Graham Nelson 961113
!
!                  Extended by Eric Eve (13-Apr-03) to provide some
!              compatibility with Glulx. 
!              This will now work with Glulx but:
!            (a) The menus are presented differently
!            (b) You can't have more than 10 items in any one menu
!
!
!   A menu is a tree of objects of class Option.  A Menu is an Option which
!   launches a fresh menu when chosen.  To choose option O, send the
!   message:
!
!       O.select();
!
!   So to start off a menu session, send this message to the top menu.
!
!   Here's a simple menu structure:
!
!       Menu "Instructions for playing Mordred";
!       Menu   -> "How to play adventure games";
!       Option -> -> "Looking around"
!                     with description "I am your eyes and ears ...";
!       Option -> -> "Taking and Dropping"
!                     with description "When you find items ...";
!       Option -> "About the author"
!                  with description "The author was born in ...";
!
!   Menus produced in this code are automatically divided into pages
!   so that they'll always fit on the screen, whatever size the screen is
!   and however many options there are.
!
!   Note that since objects can always be moved about in play, it's easy
!   to create new menu structures to fit the circumstances of the moment.
!   (For example, a hints menu which gives hints only on currently open
!   puzzles.)
!
!   You can instead write a routine to receive the "description" message.
!   Then the text printed when an option is chosen can also vary.
!
!   If you return 2 from such a routine, then the game does not prompt
!   the player to press a key before going back into the menu.
!   If you return 3, then the whole menu is closed up immediately.
!
!   Finally, you can always give your own "select" routine for an Option.
!   The rules for return values are the same; what's different is that
!   this way the screen will not be cleared and given a nice banner when
!   the option is chosen.  (Nothing visible will happen unless you do
!   it yourself.)  The SwitchOption class is an example of the kind of
!   gadget you might want this for:
!
!       Menu "Game settings";
!       SwitchOption -> FullRoomD   "full room descriptions" has on;
!       SwitchOption -> WordyP      "wordier prompts";
!       SwitchOption -> AllowSavedG "allow saved games" has on;
!
!   Choosing any of these switch-options flips them between on and off.
!   In your program, you can test
!
!       if (WordyP has on) ...
!
!   and so forth to check the current state.
! -------------------------------------------------------------------------
system_file;

Property update;

Ifndef PKEY__TX;

Constant LIB_PRE_63;

 !  Then we are using library 6/1 or 6/2, which won't have defined these:

Constant NKEY__TX     = "  N = next option";
Constant PKEY__TX     = "P = previous";
Constant QKEY1__TX    = "  Q = resume game";
Constant QKEY2__TX    = "Q = previous menu";
Constant RKEY__TX     = "RETURN = select option";

Constant NKEY1__KY    = 'N';
Constant NKEY2__KY    = 'n';
Constant PKEY1__KY    = 'P';
Constant PKEY2__KY    = 'p';
Constant QKEY1__KY    = 'Q';
Constant QKEY2__KY    = 'q';

Endif;



#ifndef WORDSIZE;
    Constant TARGET_ZCODE;
    Constant WORDSIZE 2;
#endif;



Global screen_width;
Global screen_height;
Array ForUseByOptions buffer 128;

Class Option
 with emblazon
      [ bar_height page pages temp;
          

          !   Clear screen:

          ClearScreen();
          StatusLineHeight(bar_height);

          !   Black out top line in reverse video:
          MainWindow();
          MoveCursor();
         
          MoveCursor(1, 1);
          screen_width = ScreenWidth();
          style reverse; spaces(screen_width);

#ifdef TARGET_ZCODE;
          if (standard_interpreter == 0)
              MoveCursor(1, 1);
          else

          {  ! ForUseByOptions-->0 = 128;
#endif;            
              PrintToBuffer(ForUseByOptions, 128, header, self, pages);
            
              ! @output_stream 3 ForUseByOptions;
              ! print (name) self;
              ! if (pages ~= 1) print " [", page, "/", pages, "]";
              ! @output_stream -3;
              temp = (screen_width - ForUseByOptions-->0)/2;
              MoveCursor(1, temp);
              
#ifdef TARGET_ZCODE;              
          }
#endif;
          print (name) self;
          if (pages ~= 1) print " [", page, "/", pages, "]";

          return ForUseByOptions-->0;
      ],
      
      select
      [;  self.emblazon(1, 1, 1);

          MainWindow(); font on; style roman; new_line; new_line;

          if (self provides description)
              return self.description();

          "[No text written for this option.]^";
      ],
      update [; ]
      has open
;    

Class Menu class Option
 with select
      [ count j obj pkey  line oldline top_line bottom_line
                            page pages options top_option;
       
            
         
          screen_height = ScreenHeight();
          if (screen_height == 0 or 255) screen_height = 18;
          screen_height = screen_height - 7;

          options = 0;
          objectloop (obj in self && obj ofclass Option){
            obj.update();
            if (obj has open) options++;
          }         
           
          if (options == 0) return 2;
          
          pages = 1 + options/screen_height;

          top_line = 6;

          page = 1;

          line = top_line;

          .ReDisplay;
         
          screen_width = ScreenWidth();            

          count = options - 1;
          top_option = (page - 1) * screen_height;

          self.emblazon(7 + count, page, pages);

          MoveCursor(2,1); spaces(screen_width);
          MoveCursor(2,2); print (string) NKEY__TX;

          j = screen_width-12; 
  
          MoveCursor(2,j); print (string) PKEY__TX;

          MoveCursor(3,1); spaces(screen_width);
          MoveCursor(3,2); print (string) RKEY__TX;

          j = screen_width-17; 
          
          MoveCursor(3, j);

          if (sender ofclass Option)
              print "Q = previous menu";
          else
              print "  Q = resume game";
          style roman;

          count = top_line; j = 0;
          objectloop (obj in self && obj ofclass Option && obj has open)
          {   if (j >= top_option && j < (top_option + screen_height))
              {   MoveCursor(count, 6);
                  print (name) obj;
                  count++;
              }
              j++;
          }
          bottom_line = count - 1;
          oldline = 0;

          for(::)
          {   !   Move or create the > cursor:

              if (line~=oldline)
              {   if (oldline~=0) { MoveCursor(oldline, 4); print " "; }
                  MoveCursor(line, 4); print ">";
              }
              oldline = line;

              pkey = KeyCharPrimitive(); 

              if (pkey == NKEY1__KY or NKEY2__KY or 130 or -5)
              {   !   Cursor down:
                  line++;
                  if (line > bottom_line)
                  {   line = top_line;
                      if (pages > 1)
                      {   if (page == pages) page = 1; else page++;
                          jump ReDisplay;
                      }
                  }    
                  continue;
              }

              if (pkey == PKEY1__KY or PKEY2__KY or 129 or -4)
              {   !   Cursor up:
                  line--;
                  if (line < top_line)
                  {   line = bottom_line;
                      if (pages > 1)
                      {   if (page == 1)
                          {   page = pages;
                              line = top_line
                                     + (options % screen_height) - 1;
                          }
                          else
                          {   page--; line = top_line + screen_height - 1;
                          }
                          jump ReDisplay;
                      }
                  }    
                  continue;
              }

              if (pkey==QKEY1__KY or QKEY2__KY or 27 or 131 or -8) break;

              if (pkey==10 or 13 or 132 or -6)
              {   count = 0;
                  objectloop (obj in self && obj ofclass Option && obj has open)
                  {   if (count == top_option + line - top_line) break;
                      count++;
                  }

                  switch(obj.select())
                  {   2: jump ReDisplay;
                      3: jump ExitMenu;
                  }

                  #ifdef LIB_PRE_63;
                  print "[Please press SPACE to continue.]^";
                  #ifnot;
                  L__M(##Miscellany, 53);
                  #endif;
                  pkey = KeyCharPrimitive();
                  jump ReDisplay;
              }
          }

          .ExitMenu;

          if (sender ofclass Option) return 2;

          font on; MoveCursor(1, 1);
          ClearScreen(); MainWindow();
          new_line; new_line; new_line;
          if (deadflag==0) <<Look>>;
          return 2;
      ];

!#endif;



Class SwitchOption class Option
  with short_name
       [;  print (object) self, " ";
           if (self has on) print "(on)"; else print "(off)";
           rtrue;
       ],
       select
       [;  if (self has on) give self ~on; else give self on;
           return 2;
       ];

! ------------------------------------------------------------------------

[ header obj pages;
   print (name) obj;
   if (pages ~= 1) print " [", pages, "/", pages, "]";
];

!----------------------------------------------------------------------------------------
!  The following code implements an Invisclues type hint system, which can be used in
!  one or both of two ways.
!
!  In either case use an ordinary Menu object for the top-level hint menu, and for sny
!  sub-menus you want in your hint system. Call the select routine on your hint menu
!  to display it.
!
!  Then you can either use Goals and Hints, or else combine the two by using HintGoals:
!
!  METHOD 1:
!
!  Menu hint_menu "Hints";
!  Goal -> "How do I unlock the door?";
!  Hint ->-> "What do you normally unlock a door with?";
!  Hint ->-> "Try looking for a key.";
!  Hint ->-> "It isn't far away.";
!
!  METHOD 2
!  
!  Menu hint_menu "Hints";
!  HintGoal -> "How do I unlock the door?"
!  with description
!   "What do you normally unlock a door with?"
!   "Try looking for a key."
!   "It isn't far away.";
!
!  You can use whichever of these methods you prefer. The second method involved less
!  typing and uses less objects, which makes it rather more economical on both counts.
!  The first method allows an unlimited number of hints per goal; it all allows you
!  to override either the short_name or the description method of a Hint object to
!  do more than just print a static string. Whichever method you use your hints will
!  look the same to the player. 
!
!  Both Goal and HintGoal allow you to make your hint system adaptive. A Goal or
!  HintGoal is only displayed in its menu if it has the open attribute (by default
!  it doesn't). If you want a Goal or HintGoal to start active at the beginning of
!  the game, define it with the open attribute. You can also set and unset the
!  open attribute on Goal/HintGoal objects during the course of the game to make
!  them active or inactive.
!
!  You can also make a Goal or HintGoal decide for itself whether it should be active.
!  Define their when_open and when_closed routines to return true when you want them
!  to become active and inactive respectively: e.g.:
!
!  HintGoal -> "How do I unlock the door?"    
!  with description
!   "What do you normally unlock a door with?"
!   "Try looking for a key."
!   "It isn't far away.",
!  when_open [; return room_outside_door has visited; ],
!  when closed [; return room_inside_door has visited; ];
!
!  Note that if when_closed() returns true then the Goal/HintGoal won't be active
!  whatever when_open() returns. This is normally what you want: a Goal/HintGoal becomes
!  active when a certain condition becomes true, and then no longer needs to be displayed
!  when some other condition becomes true. If you need different behaviour on a particular
!  goal, however, you can override its update() routine (which is what controls this).
!
!  There's one more sophistication: you can if you like combine the economy
!  of HintGoal with something of the greater flexibility of Goal + Hint by including
!  a Hint object or routine in the description property of a HintGoal, e.g.:
!
!  HintGoal -> "How do I unlock the door?"    
!  with description
!   "What do you normally unlock a door with?"
!    keyhint
!    keyHintRoutine,     
!  when_open [; return room_outside_door has visited; ],
!  when closed [; return room_inside_door has visited; ];
!  
!  Hint keyhint "Try looking for a key.";
!
!  [keyHintRoutine;
!     print "It isn't far away.";
!  ];
!
!  Obviously there's not much point in this particular case, but the principle might
!  be useful where you want a hint to be something more than a constant string. 
!
!  If you don't want this hint system at all, define the constant NO_HINTS before
!  including this file.
!----------------------------------------------------------------------------------------


#ifndef NO_HINTS;

! If you want a different message you can define this constant before
! including this file.

#ifndef NO_MORE_HINTS_TX;
Constant NO_MORE_HINTS_TX "^[No more hints - press SPACE to continue.]^";
#endif;

Class Goal class Option
 with
  select [obj i j k next_hint;                    
          self.emblazon(1, 1, 1);
          .ReDisplay;    
          i = 0;  
          MainWindow(); font on; style roman; new_line; new_line;
          j = children(self);
          objectloop(obj in self){
            if(++i == 1) give obj open;
            if(obj has open) {
               obj.describe(i, j);     
               k = i;          
            }
            else if(i == k + 1 && i <= j)
                 next_hint = obj;           
            }
            
            if(k < j){
               k = self.next_option();
               if(k == 'q' or 'Q' or 27 or 131 or -8) return 2;
               give next_hint open;
               ClearScreen(2);
               jump ReDisplay;
           }
           print (string) NO_MORE_HINTS_TX;
           k = keyCharPrimitive();
           return 2;                     
          
      ],
      update [;
        if(self.when_open()) give self open;
        if(self.when_closed()) give self ~open;    
      ],
      next_option [k ;
         print "^N = Next Hint; Q = Back^";           
         do
           k = keyCharPrimitive();
         until(k == 'n' or 'N' or 'q' or 'Q' or 27 or 131 or -8);  
         return k;
      ],
      when_open [; rfalse; ],
      when_closed [; rfalse; ]
  has ~open
;


Class Hint
  with describe [i j;    
    style bold;
    print "[", i, "/", j, "]  "; 
    style roman;
    if(self provides description && PrintOrRun(self, description)) rtrue;
    print_ret (name) self;          
  ]  
  
;

Class HintGoal class Goal
  with
  select [i j k m;                    
            self.emblazon(1, 1, 1);
            .ReDisplay;    
             i = 0;  
             MainWindow(); font on; style roman; new_line; new_line;
             j = self.#description / WORDSIZE;
             for(i=1: i<= self.number: i++){
               k = self.&description-->(i-1);
               m = metaclass(k);
               if(m==Object){
                 if(k ofclass hint) {
                   give k open;
                   k.describe(i, j);                               
                 }
                 else
                  print "*** Programming error: ", (name) k, " not of class Hint.^";              
               }
               else {
                 style bold;
                 print "[", i, "/", j, "]  ";
                 style roman;  
                 if(m==String)   
                    print (string) k; 
                 if(m==Routine)
                   k();   
                 new_line;               
               }               
             }             
             if(i <= j){
               k = self.next_option();               
               if(k == 'q' or 'Q' or 27 or 131 or -8) return 2;
               give self.number++;
               ClearScreen(2);
               jump ReDisplay;
           }
           print (string) NO_MORE_HINTS_TX;
           k = keyCharPrimitive();
           return 2;                     
          
      ],              
         
  number 1,       
  description 0
;


#endif; !NO_HINTS;

